% Mikoaj Czajkowski , Wiktor Budziski 
% "Simulation error in maximum likelihood estimation of discrete choice
% models"
%
% Online materials

% Script calculates Minimum tolerance level when comparing simulation
% results for given no. of draws with results for 100k draws. It is later
% used to create table in Appendix E

% 2019-03-08

% INPUT
% Simulation results estimated with 1000 repetitions for designs with 5 attributes (folder '1000')
% Simulation results estimated with 1000 repetitions for designs with 10 attributes (folder '1000_10')
% MTL function 
% Tools package (https://github.com/czaj/Ttools)

% Output:
% File: MTL_results05_E.mat

clear
clc

Output = NaN(9,9,2, 1 + 20 + 20 +4); 
    % Only Sobol, 9 numbers of draws, 9 designs, 5 or 10 attributes
    % LL, 20 for Betas, 20 for Z stats
    % Explanatory: Number of draws
    
% 
Tmp = [100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000]; 
for i = 1:9
    Output(i,:,:,42) = Tmp(i); 
end
% NCT
Output(:,[1:3],:,43) = 4; %
Output(:,[4:6],:,43) = 8; %
Output(:,[7:9],:,43) = 12; %
% NP
Output(:,[1:3:7],:,44) = 400; %
Output(:,[2:3:8],:,44) = 800; %
Output(:,[3:3:9],:,44) = 1200; %
% Att
Output(:,:,1,45) = 5; %
Output(:,:,2,45) = 10; %

Alpha = 0.05; % Confidence level for MTL
Directory1 = 'C:\Users\wbudzinski\Documents\Drawy\Codes\1000'; % Directory to the first folder
Directory2 = 'C:\Users\wbudzinski\Documents\Drawy\Codes\1000_10'; % Directory to the third folder

%% First loop

cd(Directory1) % Directory for files with simulation results
files = dir('*.mat');

d = 0;
for file = files'
    

   d = d+1;
   if d > 9 && d <=18 % only MXL
       load(file.name);
       % Calculations for LL
       TrueLL = SimResults.LL(:,10,4); % only 100 for 100k
        for j = 1:7 % Different number of draws
            [theta] = MTL([SimResults.LL(:,j,4), TrueLL], [1,0;0,1], chi2inv(0.95,1), 2,[],[], Alpha);
             Output(j,d-9,1,1) = theta;
        end
        for j = 8:9 % Different number of draws
            [theta] = MTL([SimResults.LL(1:100,j,4), SimResults.LL(1:100,10,4)], [1,0;0,1], chi2inv(0.95,1), 2,[],[], Alpha);
            Output(j,d-9,1,1) = theta;
        end
       
        % Calculations for Betas & Z stats
        TrueB = SimResults.b(:,:,10,4);
        TrueStd = SimResults.b(:,:,10,4)./SimResults.std(:,:,10,4);

        for j = 1:7 % Different number of draws
             for k = 1:10 %
                 [theta] = MTL([SimResults.b(k,:,j,4)', TrueB(k,:)'], [1,0;0,1], 1, 2,[],[], Alpha);
                 Output(j,d-9,1,1+k) = theta;

                 tmpx = isnan(SimResults.std(k,:,j,4));
                 [theta] = MTL([SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)', TrueStd(k,~tmpx)'], [1,0;0,1], 2, 2,[],[], Alpha);
                 Output(j,d-9,1,21+k) = theta;

             end
        end

        for j = 8:9
            for k = 1:10 %
                 [theta] = MTL([SimResults.b(k,1:100,j,4)', SimResults.b(k,1:100,10,4)'], [1,0;0,1], 1, 2,[],[], Alpha);
                 Output(j,d-9,1,1+k) = theta;

                 tmpx = isnan(SimResults.std(k,:,j,4));
                 [theta] = MTL([SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)', SimResults.b(k,~tmpx,10,4)'./SimResults.std(k,~tmpx,10,4)'], [1,0;0,1], 2, 2,[],[], Alpha);
                 Output(j,d-9,1,21+k) = theta;

             end
        end
   end
    
end

%% Second loop
cd(Directory2) % Directory for files with simulation results
files = dir('*.mat');
d = 0;

for file = files'
    
   load(file.name);
   SimResults.LL(SimResults.LL == 0) = NaN;
   SimResults.b(SimResults.b == 0) = NaN;
   SimResults.std(SimResults.std == 0) = NaN;

   % Calculations for LL
   TrueLL = SimResults.LL(:,10,4); % only 100 for 100k
    for j = 1:7 % Different number of draws
        [theta] = MTL([SimResults.LL(:,j,4), TrueLL], [1,0;0,1], chi2inv(0.95,1), 2,[],[], Alpha);
         Output(j,d,2,1) = theta;
    end
    for j = 8:9 % Different number of draws
        [theta] = MTL([SimResults.LL(:,j,4), SimResults.LL(:,10,4)], [1,0;0,1], chi2inv(0.95,1), 2,[],[], Alpha);
        Output(j,d,2,1) = theta;
    end

    % Calculations for Betas & Z stats
    TrueB = SimResults.b(:,:,10,4);
    TrueStd = SimResults.b(:,:,10,4)./SimResults.std(:,:,10,4);

    for j = 1:7 % Different number of draws
         for k = 1:20 %
             [theta] = MTL([SimResults.b(k,:,j,4)', TrueB(k,:)'], [1,0;0,1], 1, 2,[],[], Alpha);
             Output(j,d,2,1+k) = theta;

             tmpx = isnan(SimResults.std(k,:,j,4));
             [theta] = MTL([SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)', TrueStd(k,~tmpx)'], [1,0;0,1], 2, 2,[],[], Alpha);
             Output(j,d,2,21+k) = theta;

         end
    end

    for j = 8:9
        for k = 1:20 %
             [theta] = MTL([SimResults.b(k,:,j,4)', SimResults.b(k,:,10,4)'], [1,0;0,1], 1, 2,[],[], Alpha);
             Output(j,d,2,1+k) = theta;

             tmpx = isnan(SimResults.std(k,:,j,4));
             [theta] = MTL([SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)', SimResults.b(k,~tmpx,10,4)'./SimResults.std(k,~tmpx,10,4)'], [1,0;0,1], 2, 2,[],[], Alpha);
             Output(j,d,2,21+k) = theta;

         end
    end
    
end

Output = reshape(Output, [9*9*2, 45]);

cd('C:\Users\wbudzinski\Documents\Drawy\Codes') % Directory for files with simulation results
save('MTL_results05_E.mat','Output','Alpha')